// -----------------------------------------------------------
// Przykad bardzo prostej wtyczki DSP do WinAmpa 2.x
// Wiktor Zychla (c) 2003
// 
// Kod naley skompilowa jako bibliotek DLL,
// umieci w folderze wtyczek WinAmpa, a nastpnie
// skonfigurowa program tak, aby korzysta z wtyczki
// przy odtwarzaniu dwiku.
#include <windows.h>

#ifdef __cplusplus
#define EXPORT extern "C" __declspec (dllexport)
#else
#define EXPORT __declspec (dllexport)
#endif

// -----------------------------------------------------------
// Definicje struktur DSP uywanych przez WinAmpa 2.x
typedef struct winampDSPModule
{
  char*  description;
  HWND   hwndParent;
  HANDLE hDllInstance;
  void   (*Config)         ( winampDSPModule *module );
  int    (*Init)           ( winampDSPModule *module );
  int    (*Modify_Samples) ( winampDSPModule *module, 
                             short int* samples, 
                             int numSamples, 
                             int bps, int nch, int srate );
  void   (*Quit)           ( winampDSPModule *module );
  char*  userData;
} winampDSPModule;

typedef struct 
{
  int   version;
  char* description;
  winampDSPModule* (*getModule)( int i );
} winampDSPHeader;

// -----------------------------------------------------------
// Deklaracje wyprzedzajce
const int DSP_HDRver          = 0x20;
void Config                   ( winampDSPModule *module );
int  Init                     ( winampDSPModule *module );
int  Modify_Samples_WideStereo( winampDSPModule *module, 
                                short int* samples, 
                                int numSamples, 
                                int bps, int nch, int srate );
void Quit                     ( winampDSPModule *module );
winampDSPModule* GetModule( int moduleNo );

// -----------------------------------------------------------
// Nagwek wtyczki oraz opis jedynego moduu DSP
winampDSPHeader PluginHeader =
{ DSP_HDRver, "Najprostszy modu DSP v.0.1", GetModule };

winampDSPModule WideStereo_Module =
{ "Efekt 'wide stereo'", 0, 0, 
  Config, Init, Modify_Samples_WideStereo, Quit };
		
// -----------------------------------------------------------
// Funkcja przekazujca WinAmpowi informacje o wtyczkach 
winampDSPModule* GetModule( int moduleNo ) 
{
  switch( moduleNo )
  {
    case 0  : return &WideStereo_Module;
    default : return NULL;
  }
}

// -----------------------------------------------------------
// Implementacje funkcji wtyczki
int  Init( winampDSPModule *module ) { return 0; }

void Config( winampDSPModule *module ) 
{
  MessageBox( 0, "Najprostsza wtyczka do WinAmpa.\r\n"
                 "Demonstracja efektu 'wide-stereo.", 
                 "Modu DSP dla WinAmpa", MB_OK | MB_ICONINFORMATION );
}

void Quit( winampDSPModule *module ) {}

int Modify_Samples_WideStereo( winampDSPModule *module, 
                               short int* samples, 
                               int numSamples, 
                               int bps, int nch, int srate )
{
  int Pos, PosX2, LR, L, R;
  if ( nch == 2 )
  {
    PosX2 = 0;
    for ( Pos = 0; Pos < numSamples; Pos++ )
    {
      LR = samples[ PosX2+1 ] - samples[ PosX2 ];
      L  = ( -samples[ PosX2   ] + LR ) / 2;
      R  = (  samples[ PosX2+1 ] + LR ) / 2;

      if ( L < -32768 ) L = -32768; if ( L > 32767 ) L = 32767;
      if ( R < -32768 ) R = -32768; if ( R > 32767 ) R = 32767;

      samples[ PosX2   ] = L;
      samples[ PosX2+1 ] = R;

      PosX2+=2;
    }
  }

  return numSamples;
}

// -----------------------------------------------------------
// Przekazanie WinAmpowi nagwka wtyczki
EXPORT winampDSPHeader* winampDSPGetHeader2()
{
  return &PluginHeader;
}

// -----------------------------------------------------------
// Funkcja inicjujca bibliotek
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fwdreason, 
                    LPVOID lpvReserved)
{
  return 1;
}

